/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.task;

import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import org.junit.runners.model.Statement;

public class PerformanceEvaluationTask
implements Runnable {
    private long warmUpNs;
    private final Statement statement;
    private StatisticsCalculator statisticsCalculator;
    private volatile boolean isContinue;

    public PerformanceEvaluationTask(long warmUpNs, Statement statement, StatisticsCalculator statisticsCalculator) {
        this.warmUpNs = warmUpNs;
        this.statement = statement;
        this.statisticsCalculator = statisticsCalculator;
        this.isContinue = true;
    }

    @Override
    public void run() {
        long startTimeNs = System.nanoTime();
        long startMeasurements = startTimeNs + this.warmUpNs;
        while (this.isContinue) {
            this.evaluateStatement(startMeasurements);
        }
    }

    private void evaluateStatement(long startMeasurements) {
        if (!this.isContinue) {
            return;
        }
        if (System.nanoTime() < startMeasurements) {
            try {
                this.statement.evaluate();
            }
            catch (Throwable throwable) {}
        } else {
            long startTimeNs = System.nanoTime();
            try {
                this.statement.evaluate();
                this.statisticsCalculator.addLatencyMeasurement(this.getCostTimeNs(startTimeNs));
                this.statisticsCalculator.incrementEvaluationCount();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                this.statisticsCalculator.incrementEvaluationCount();
                this.statisticsCalculator.incrementErrorCount();
                this.statisticsCalculator.addLatencyMeasurement(this.getCostTimeNs(startTimeNs));
            }
        }
    }

    private long getCostTimeNs(long startTimeNs) {
        long currentTimeNs = System.nanoTime();
        return currentTimeNs - startTimeNs;
    }

    public boolean isContinue() {
        return this.isContinue;
    }

    public void setContinue(boolean aContinue) {
        this.isContinue = aContinue;
    }
}

