/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.core.report.impl;

import com.github.houbb.junitperf.constant.enums.StatusEnum;
import com.github.houbb.junitperf.core.report.Reporter;
import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import com.github.houbb.junitperf.model.evaluation.EvaluationContext;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationConfig;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationRequire;
import com.github.houbb.junitperf.model.evaluation.component.EvaluationResult;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.core.LogFactory;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="2_0_0")
public class ConsoleReporter
implements Reporter {
    private static final Log log = LogFactory.getLog(ConsoleReporter.class);

    @Override
    public void report(Class testClass, Set<EvaluationContext> evaluationContextSet) {
        for (EvaluationContext context : evaluationContextSet) {
            StatisticsCalculator statistics = context.getStatisticsCalculator();
            EvaluationConfig evaluationConfig = context.getEvaluationConfig();
            EvaluationRequire evaluationRequire = context.getEvaluationRequire();
            EvaluationResult evaluationResult = context.getEvaluationResult();
            String throughputStatus = this.getStatus(evaluationResult.isTimesPerSecondAchieved());
            log.info("Started at:   {}", new Object[]{context.getStartTime()});
            log.info("Invocations:  {}", new Object[]{statistics.getEvaluationCount()});
            log.info("Success:  {}", new Object[]{statistics.getEvaluationCount() - statistics.getErrorCount()});
            log.info("Errors:   {}", new Object[]{statistics.getErrorCount()});
            log.info("Thread Count: {}", new Object[]{evaluationConfig.getConfigThreads()});
            log.info("Warm up:      {}ms", new Object[]{evaluationConfig.getConfigWarmUp()});
            log.info("Execution time: {}ms", new Object[]{evaluationConfig.getConfigDuration()});
            log.info("Throughput:     {}/s (Required: {}/s) - {}", new Object[]{evaluationResult.getThroughputQps(), evaluationRequire.getRequireTimesPerSecond(), throughputStatus});
            log.info("Min latency:   {}ms (Required: {}ms) - {}", new Object[]{Float.valueOf(statistics.getMinLatency(TimeUnit.MILLISECONDS)), Float.valueOf(evaluationRequire.getRequireMin()), this.getStatus(evaluationResult.isMinAchieved())});
            log.info("Max latency:    {}ms (Required: {}ms) - {}", new Object[]{Float.valueOf(statistics.getMaxLatency(TimeUnit.MILLISECONDS)), Float.valueOf(evaluationRequire.getRequireMax()), this.getStatus(evaluationResult.isMaxAchieved())});
            log.info("Ave latency:    {}ms (Required: {}ms) - {}", new Object[]{Float.valueOf(statistics.getMeanLatency(TimeUnit.MILLISECONDS)), Float.valueOf(evaluationRequire.getRequireAverage()), this.getStatus(evaluationResult.isAverageAchieved())});
            for (Map.Entry<Integer, Float> entry : evaluationRequire.getRequirePercentilesMap().entrySet()) {
                Integer percentile = entry.getKey();
                Float threshold = entry.getValue();
                boolean result = evaluationResult.getIsPercentilesAchievedMap().get(percentile);
                String percentileStatus = this.getStatus(result);
                log.info("Percentile: {}%%    {}ms (Required: {}ms) - {}", new Object[]{percentile, Float.valueOf(statistics.getLatencyPercentile(percentile, TimeUnit.MILLISECONDS)), threshold, percentileStatus});
            }
        }
    }

    private String getStatus(boolean isSuccess) {
        if (isSuccess) {
            return StatusEnum.PASSED.getStatus();
        }
        return StatusEnum.FAILED.getStatus();
    }
}

