/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.junitperf.support.task;

import com.github.houbb.junitperf.core.statistics.StatisticsCalculator;
import java.lang.reflect.Method;

public class PerformanceEvaluationTask
implements Runnable {
    private final long warmUpNs;
    private final StatisticsCalculator statisticsCalculator;
    private volatile boolean isContinue;
    private final Object testInstance;
    private final Method testMethod;

    public PerformanceEvaluationTask(long warmUpNs, StatisticsCalculator statisticsCalculator, Object testInstance, Method testMethod) {
        this.warmUpNs = warmUpNs;
        this.statisticsCalculator = statisticsCalculator;
        this.testInstance = testInstance;
        this.testMethod = testMethod;
        this.isContinue = true;
    }

    @Override
    public void run() {
        long startTimeNs = System.nanoTime();
        long startMeasurements = startTimeNs + this.warmUpNs;
        while (this.isContinue) {
            this.evaluateStatement(startMeasurements);
        }
    }

    private void evaluateStatement(long startMeasurements) {
        if (!this.isContinue) {
            return;
        }
        if (System.nanoTime() < startMeasurements) {
            try {
                this.testMethod.invoke(this.testInstance, new Object[0]);
            }
            catch (Throwable throwable) {}
        } else {
            long startTimeNs = System.nanoTime();
            try {
                this.testMethod.invoke(this.testInstance, new Object[0]);
                this.statisticsCalculator.addLatencyMeasurement(this.getCostTimeNs(startTimeNs));
                this.statisticsCalculator.incrementEvaluationCount();
            }
            catch (Throwable throwable) {
                this.statisticsCalculator.incrementEvaluationCount();
                this.statisticsCalculator.incrementErrorCount();
                this.statisticsCalculator.addLatencyMeasurement(this.getCostTimeNs(startTimeNs));
            }
        }
    }

    private long getCostTimeNs(long startTimeNs) {
        long currentTimeNs = System.nanoTime();
        return currentTimeNs - startTimeNs;
    }

    public boolean isContinue() {
        return this.isContinue;
    }

    public void setContinue(boolean aContinue) {
        this.isContinue = aContinue;
    }
}

