package com.github.houbb.load.balance.api.impl;

import com.github.houbb.load.balance.api.ILoadBalance;
import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.List;

/**
 * @author binbin.hou
 * @since 0.0.1
 */
public abstract class AbstractLoadBalance<T extends IServer> implements ILoadBalance<T> {

    @Override
    public T select(ILoadBalanceContext<T> context) {
        List<T> servers = context.servers();

        if(servers.size() <= 1) {
            return servers.get(0);
        }

        return doSelect(context);
    }

    /**
     * 执行选择
     * @param context 上下文
     * @return 结果
     * @since 0.0.1
     */
    protected abstract T doSelect(final ILoadBalanceContext<T> context);

}
