package com.github.houbb.load.balance.api.impl;

import com.github.houbb.hash.api.IHashCode;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.List;

/**
 * 普通 hash 策略
 * @author binbin.hou
 * @since 0.0.1
 */
@ThreadSafe
public class LoadBalanceCommonHash<T extends IServer> extends AbstractLoadBalanceHash<T> {

    public LoadBalanceCommonHash(IHashCode hashCode) {
        super(hashCode);
    }

    @Override
    protected T doSelect(ILoadBalanceContext<T> context) {
        List<T> servers = context.servers();

        final String hashKey = context.hashKey();
        int code = hashCode.hash(hashKey);
        int hashCode = Math.abs(code);
        int index = hashCode % servers.size();
        return servers.get(index);
    }

}
