package com.github.houbb.load.balance.api.impl;

import com.github.houbb.consistent.hashing.api.IConsistentHashing;
import com.github.houbb.consistent.hashing.bs.ConsistentHashingBs;
import com.github.houbb.hash.api.IHash;
import com.github.houbb.hash.api.IHashCode;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.List;

/**
 * 一致性 hash 策略
 *
 * @author binbin.hou
 * @since 0.0.1
 */
@ThreadSafe
public class LoadBalanceConsistentHash<T extends IServer> extends AbstractLoadBalanceHash<T> {

    public LoadBalanceConsistentHash(IHashCode hashCode) {
        super(hashCode);
    }

    @Override
    protected T doSelect(ILoadBalanceContext<T> context) {
        IConsistentHashing<T> consistentHashing = ConsistentHashingBs
                .<T>newInstance()
                .hashCode(hashCode)
                .nodes(context.servers())
                .build();

        final String hashKey = context.hashKey();
        return consistentHashing.get(hashKey);
    }

}
