package com.github.houbb.load.balance.api.impl;

import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.List;

/**
 * @author binbin.hou
 * @since 0.0.1
 */
public class LoadBalanceContext<T extends IServer> implements ILoadBalanceContext<T> {

    private String hashKey;

    /**
     * 服务端列表
     * @since 0.0.3
     */
    private List<T> servers;

    /**
     * 新建对象实例
     * @since 0.0.1
     * @return this
     */
    public static <T extends IServer> LoadBalanceContext<T> newInstance() {
        return new LoadBalanceContext<>();
    }

    @Override
    public String hashKey() {
        return hashKey;
    }

    public LoadBalanceContext<T> hashKey(String hashKey) {
        this.hashKey = hashKey;
        return this;
    }

    @Override
    public List<T> servers() {
        return servers;
    }

    public LoadBalanceContext<T> servers(List<T> servers) {
        this.servers = servers;
        return this;
    }

    @Override
    public String toString() {
        return "LoadBalanceContext{" +
                "hashKey='" + hashKey + '\'' +
                ", servers=" + servers +
                '}';
    }

}
