package com.github.houbb.load.balance.api.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

/**
 * 随机策略
 * @author binbin.hou
 * @since 0.0.1
 */
@ThreadSafe
public class LoadBalanceRandom<T extends IServer> extends AbstractLoadBalance<T>{

    @Override
    protected T doSelect(ILoadBalanceContext<T> context) {
        List<T> servers = context.servers();

        Random random = ThreadLocalRandom.current();
        int nextIndex = random.nextInt(servers.size());
        return servers.get(nextIndex);
    }

}
