package com.github.houbb.load.balance.api.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

/**
 * 轮训策略
 *
 * @author binbin.hou
 * @since 0.0.1
 */
@ThreadSafe
public class LoadBalanceRoundRobbin<T extends IServer> extends AbstractLoadBalance<T> {

    /**
     * 位移指针
     * @since 0.0.1
     */
    private final AtomicLong indexHolder = new AtomicLong();

    @Override
    protected T doSelect(ILoadBalanceContext<T> context) {
        List<T> servers = context.servers();

        long index = indexHolder.getAndIncrement();
        int actual = (int) (index % servers.size());
        return servers.get(actual);
    }

}
