package com.github.houbb.load.balance.api.impl;

import com.github.houbb.hash.api.IHashCode;
import com.github.houbb.load.balance.api.ILoadBalance;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.List;

/**
 * 工具类
 * @author binbin.hou
 * @since 0.0.1
 */
public final class LoadBalances {

    private LoadBalances(){}

    /**
     * 随机
     * @return 结果
     * @since 0.0.1
     */
    public static <T extends IServer> ILoadBalance<T> random() {
        return new LoadBalanceRandom<>();
    }

    /**
     * 轮训
     * @return 结果
     * @since 0.0.1
     */
    public static <T extends IServer> ILoadBalance<T> roundRobbin() {
        return new LoadBalanceRoundRobbin<>();
    }

    /**
     * 权重轮训
     * @return 结果
     * @since 0.0.1
     */
    public static <T extends IServer> ILoadBalance<T> weightRoundRobbin() {
        return new LoadBalanceWeightRoundRobbin<>();
    }

    /**
     * 普通 Hash
     * @param hashCode 哈希策略
     * @return 结果
     * @since 0.0.1
     */
    public static <T extends IServer> ILoadBalance<T> commonHash(final IHashCode hashCode) {
        return new LoadBalanceCommonHash<>(hashCode);
    }

    /**
     * 一致性 Hash
     * @param hashCode 哈希策略
     * @return 结果
     * @since 0.0.1
     */
    public static <T extends IServer> ILoadBalance<T> consistentHash(final IHashCode hashCode) {
        return new LoadBalanceConsistentHash<>(hashCode);
    }

}
