package com.github.houbb.load.balance.bs;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.load.balance.api.ILoadBalance;
import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.api.impl.LoadBalanceContext;
import com.github.houbb.load.balance.api.impl.LoadBalances;
import com.github.houbb.load.balance.support.server.IServer;

import java.util.ArrayList;
import java.util.List;

/**
 * 负载均衡引导类
 *
 * @author binbin.hou
 * @since 0.0.1
 */
public final class LoadBalanceBs<T extends IServer> {

    /**
     * 引导类私有化
     * @since 0.0.1
     */
    private LoadBalanceBs(){}

    /**
     * 新建对象实例
     * @return 实例
     * @since 0.0.1
     */
    public static <T extends IServer> LoadBalanceBs<T> newInstance() {
        return new LoadBalanceBs<>();
    }

    /**
     * 负载策略
     * @since 0.0.1
     */
    private ILoadBalance<T> loadBalance = LoadBalances.random();

    /**
     * hash key
     * @since 0.0.3
     */
    private String hashKey = "";

    /**
     * 服务器列表
     * @since 0.0.3
     */
    private List<T> servers = new ArrayList<>();

    /**
     * 设置负载策略
     * @param loadBalance 负载策略
     * @return 结果
     * @since 0.0.1
     */
    public LoadBalanceBs<T> loadBalance(ILoadBalance<T> loadBalance) {
        ArgUtil.notNull(loadBalance, "loadBalance");

        this.loadBalance = loadBalance;
        return this;
    }

    public LoadBalanceBs<T> hashKey(String hashKey) {
        this.hashKey = hashKey;
        return this;
    }

    public LoadBalanceBs<T> servers(List<T> servers) {
        ArgUtil.notEmpty(servers, "servers");
        this.servers = servers;
        return this;
    }

    /**
     * 选择对应的服务器信息
     * @return 结果
     * @since 0.0.1
     */
    public T select() {
        ArgUtil.notEmpty(servers, "servers");
        ArgUtil.notNull(loadBalance, "loadBalance");

        ILoadBalanceContext<T> context = LoadBalanceContext
                .<T>newInstance()
                .hashKey(hashKey)
                .servers(servers);

        return loadBalance.select(context);
    }

}
