package com.github.houbb.load.balance.support.server.impl;

import com.github.houbb.load.balance.support.server.IServer;

import java.util.Objects;

/**
 * 服务器信息
 * @author binbin.hou
 * @since 0.0.1
 */
public class Server implements IServer {

    /**
     * 地址
     * @since 0.0.1
     */
    private String url;

    /**
     * 权重
     * @since 0.0.1
     */
    private int weight;

    public static Server newInstance() {
        return new Server();
    }

    /**
     * 实现
     * @param url 地址
     * @param weight 权重
     * @return this
     * @since 0.0.2
     */
    public static Server of(final String url, final int weight) {
        return newInstance().url(url).weight(weight);
    }

    /**
     * 实现
     * @param url 地址
     * @return this
     * @since 0.0.2
     */
    public static Server of(final String url) {
        return of(url, 1);
    }

    @Override
    public String url() {
        return url;
    }

    public Server url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public int weight() {
        return weight;
    }

    public Server weight(int weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public String toString() {
        return "Server{" +
                "url='" + url + '\'' +
                ", weight=" + weight +
                '}';
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || getClass() != object.getClass()) {
            return false;
        }
        Server server = (Server) object;
        return weight == server.weight &&
                Objects.equals(url, server.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, weight);
    }
}
