/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.load.balance.api.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.support.filter.IFilter;
import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.MathUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.load.balance.api.ILoadBalanceContext;
import com.github.houbb.load.balance.api.impl.AbstractLoadBalance;
import com.github.houbb.load.balance.support.server.IServer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public class LoadBalanceWeightRoundRobbin<T extends IServer>
extends AbstractLoadBalance<T> {
    private final AtomicLong indexHolder = new AtomicLong();

    @Override
    protected T doSelect(ILoadBalanceContext<T> context) {
        List<T> servers = context.servers();
        List<T> actualList = this.buildActualList(servers);
        long index = this.indexHolder.getAndIncrement();
        int actual = (int)(index % (long)actualList.size());
        return (T)((IServer)actualList.get(actual));
    }

    private List<T> buildActualList(List<T> serverList) {
        ArrayList<IServer> actualList = new ArrayList<IServer>();
        List notZeroServers = CollectionUtil.filterList(serverList, (IFilter)new IFilter<T>(){

            public boolean filter(IServer iServer) {
                return iServer.weight() <= 0;
            }
        });
        List weightList = CollectionUtil.toList((Iterable)notZeroServers, (IHandler)new IHandler<T, Integer>(){

            public Integer handle(T iServer) {
                return iServer.weight();
            }
        });
        int maxDivisor = MathUtil.ngcd((List)weightList);
        for (IServer server : notZeroServers) {
            int weight = server.weight();
            int times = weight / maxDivisor;
            for (int i = 0; i < times; ++i) {
                actualList.add(server);
            }
        }
        return actualList;
    }
}

