/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.load.balance.bs;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.load.balance.api.ILoadBalance;
import com.github.houbb.load.balance.api.impl.LoadBalanceContext;
import com.github.houbb.load.balance.api.impl.LoadBalances;
import com.github.houbb.load.balance.support.server.IServer;
import java.util.ArrayList;
import java.util.List;

public final class LoadBalanceBs<T extends IServer> {
    private ILoadBalance<T> loadBalance = LoadBalances.random();
    private String hashKey = "";
    private List<T> servers = new ArrayList<T>();

    private LoadBalanceBs() {
    }

    public static <T extends IServer> LoadBalanceBs<T> newInstance() {
        return new LoadBalanceBs<T>();
    }

    public LoadBalanceBs<T> loadBalance(ILoadBalance<T> loadBalance) {
        ArgUtil.notNull(loadBalance, (String)"loadBalance");
        this.loadBalance = loadBalance;
        return this;
    }

    public LoadBalanceBs<T> hashKey(String hashKey) {
        this.hashKey = hashKey;
        return this;
    }

    public LoadBalanceBs<T> servers(List<T> servers) {
        ArgUtil.notEmpty(servers, (String)"servers");
        this.servers = servers;
        return this;
    }

    public T select() {
        ArgUtil.notEmpty(this.servers, (String)"servers");
        ArgUtil.notNull(this.loadBalance, (String)"loadBalance");
        LoadBalanceContext context = LoadBalanceContext.newInstance().hashKey(this.hashKey).servers(this.servers);
        return this.loadBalance.select(context);
    }
}

