/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.load.balance.support.server.impl;

import com.github.houbb.load.balance.support.server.IServer;
import java.util.Objects;

public class Server
implements IServer {
    private String url;
    private int weight;

    public static Server newInstance() {
        return new Server();
    }

    public static Server of(String url, int weight) {
        return Server.newInstance().url(url).weight(weight);
    }

    public static Server of(String url) {
        return Server.of(url, 1);
    }

    @Override
    public String url() {
        return this.url;
    }

    public Server url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public Server weight(int weight) {
        this.weight = weight;
        return this;
    }

    public String toString() {
        return "Server{url='" + this.url + '\'' + ", weight=" + this.weight + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Server server = (Server)object;
        return this.weight == server.weight && Objects.equals(this.url, server.url);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.weight);
    }
}

