/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.load.balance.util;

import com.github.houbb.hash.api.IHashCode;
import com.github.houbb.load.balance.api.impl.LoadBalances;
import com.github.houbb.load.balance.bs.LoadBalanceBs;
import com.github.houbb.load.balance.support.server.IServer;
import java.util.List;

public final class LoadBalanceHelper {
    private LoadBalanceHelper() {
    }

    public static <T extends IServer> T random(List<T> servers) {
        return LoadBalanceBs.newInstance().servers(servers).loadBalance(LoadBalances.random()).select();
    }

    public static <T extends IServer> T roundRobbin(List<T> servers) {
        return LoadBalanceBs.newInstance().servers(servers).loadBalance(LoadBalances.roundRobbin()).select();
    }

    public static <T extends IServer> T weightRoundRobbin(List<T> servers) {
        return LoadBalanceBs.newInstance().servers(servers).loadBalance(LoadBalances.weightRoundRobbin()).select();
    }

    public static <T extends IServer> T commonHash(List<T> servers, IHashCode hash, String hashKey) {
        return LoadBalanceBs.newInstance().servers(servers).hashKey(hashKey).loadBalance(LoadBalances.commonHash(hash)).select();
    }

    public static <T extends IServer> T consistentHash(List<T> servers, IHashCode hash, String hashKey) {
        return LoadBalanceBs.newInstance().servers(servers).hashKey(hashKey).loadBalance(LoadBalances.consistentHash(hash)).select();
    }
}

