/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.load.balance.api.impl;

import com.github.houbb.hash.api.IHashCode;
import com.github.houbb.load.balance.api.ILoadBalance;
import com.github.houbb.load.balance.api.impl.LoadBalanceCommonHash;
import com.github.houbb.load.balance.api.impl.LoadBalanceConsistentHash;
import com.github.houbb.load.balance.api.impl.LoadBalanceRandom;
import com.github.houbb.load.balance.api.impl.LoadBalanceRoundRobbin;
import com.github.houbb.load.balance.api.impl.LoadBalanceWeightRoundRobbin;
import com.github.houbb.load.balance.support.server.IServer;

public final class LoadBalances {
    private LoadBalances() {
    }

    public static <T extends IServer> ILoadBalance<T> random() {
        return new LoadBalanceRandom();
    }

    public static <T extends IServer> ILoadBalance<T> roundRobbin() {
        return new LoadBalanceRoundRobbin();
    }

    public static <T extends IServer> ILoadBalance<T> weightRoundRobbin() {
        return new LoadBalanceWeightRoundRobbin();
    }

    public static <T extends IServer> ILoadBalance<T> commonHash(IHashCode hashCode) {
        return new LoadBalanceCommonHash(hashCode);
    }

    public static <T extends IServer> ILoadBalance<T> consistentHash(IHashCode hashCode) {
        return new LoadBalanceConsistentHash(hashCode);
    }
}

