/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.slf4j;

import com.github.houbb.log.integration.adaptors.slf4j.Slf4jLocationAwareLoggerImpl;
import com.github.houbb.log.integration.adaptors.slf4j.Slf4jLoggerImpl;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jImpl
implements Log {
    private Log log;

    public Slf4jImpl(String clazz) {
        Logger logger = LoggerFactory.getLogger((String)clazz);
        try {
            logger.getClass().getMethod("log", Marker.class, String.class, Integer.TYPE, String.class, Object[].class, Throwable.class);
            this.log = new Slf4jLocationAwareLoggerImpl((LocationAwareLogger)logger);
            return;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            if (logger instanceof LocationAwareLogger) {
                // empty if block
            }
            this.log = new Slf4jLoggerImpl(logger);
            return;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isFatalEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    @Override
    public void fatal(String s, Throwable e) {
        this.log.fatal(s, e);
    }

    @Override
    public void fatal(String s) {
        this.log.fatal(s);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.error(s, e);
    }

    @Override
    public void error(String s) {
        this.log.error(s);
    }

    @Override
    public void debug(String s) {
        this.log.debug(s);
    }

    @Override
    public void trace(String s) {
        this.log.trace(s);
    }

    @Override
    public void warn(String s) {
        this.log.warn(s);
    }

    @Override
    public void info(String s) {
        this.log.info(s);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        this.log.fatal(LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void fatal(String s, Object ... params) {
        this.log.fatal(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.log.error(LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.log.error(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void debug(String s, Object ... params) {
        this.log.debug(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void trace(String s, Object ... params) {
        this.log.trace(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void warn(String s, Object ... params) {
        this.log.warn(LogUtil.getLogInfo(s, params));
    }

    @Override
    public void info(String s, Object ... params) {
        this.log.info(LogUtil.getLogInfo(s, params));
    }
}

