/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.slf4j;

import com.github.houbb.log.integration.adaptors.slf4j.Slf4jImpl;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.ExceptionUtil;
import com.github.houbb.log.integration.util.LogUtil;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

class Slf4jLocationAwareLoggerImpl
implements Log {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"LOG-INTEGRATION");
    private static final String FQCN = Slf4jImpl.class.getName();
    private LocationAwareLogger logger;

    Slf4jLocationAwareLoggerImpl(LocationAwareLogger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void fatal(String s, Throwable e) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void fatal(String s) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void error(String s, Throwable e) {
        this.logger.log(MARKER, FQCN, 40, s, null, e);
    }

    @Override
    public void error(String s) {
        this.logger.log(MARKER, FQCN, 40, s, null, null);
    }

    @Override
    public void debug(String s) {
        this.logger.log(MARKER, FQCN, 10, s, null, null);
    }

    @Override
    public void trace(String s) {
        this.logger.log(MARKER, FQCN, 0, s, null, null);
    }

    @Override
    public void warn(String s) {
        this.logger.log(MARKER, FQCN, 30, s, null, null);
    }

    @Override
    public void info(String s) {
        this.logger.log(MARKER, FQCN, 20, s, null, null);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void fatal(String s, Object ... params) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.logger.log(MARKER, FQCN, 40, LogUtil.getLogInfo(s, params), null, e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.logger.log(MARKER, FQCN, 40, LogUtil.getLogInfo(s, params), null, null);
    }

    @Override
    public void debug(String s, Object ... params) {
        this.logger.log(MARKER, FQCN, 10, LogUtil.getLogInfo(s, params), null, null);
    }

    @Override
    public void trace(String s, Object ... params) {
        this.logger.log(MARKER, FQCN, 0, LogUtil.getLogInfo(s, params), null, null);
    }

    @Override
    public void warn(String s, Object ... params) {
        this.logger.log(MARKER, FQCN, 30, LogUtil.getLogInfo(s, params), null, null);
    }

    @Override
    public void info(String s, Object ... params) {
        this.logger.log(MARKER, FQCN, 20, LogUtil.getLogInfo(s, params), null, null);
    }
}

