/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.stdout;

import com.github.houbb.log.integration.constant.Level;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.LogUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StdOutExImpl
implements Log {
    public StdOutExImpl(String clazz) {
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public boolean isErrorEnabled() {
        return false;
    }

    @Override
    public boolean isFatalEnabled() {
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public boolean isWarnEnabled() {
        return false;
    }

    @Override
    public void fatal(String s, Throwable e) {
        this.log(Level.FATAL, s, e);
    }

    @Override
    public void fatal(String s) {
        this.log(Level.FATAL, s);
    }

    @Override
    public void error(String s, Throwable e) {
        this.log(Level.ERROR, s, e);
    }

    @Override
    public void error(String s) {
        this.log(Level.ERROR, s);
    }

    @Override
    public void debug(String s) {
        this.log(Level.DEBUG, s);
    }

    @Override
    public void trace(String s) {
        this.log(Level.TRACE, s);
    }

    @Override
    public void warn(String s) {
        this.log(Level.WARN, s);
    }

    @Override
    public void info(String s) {
        this.log(Level.INFO, s);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        this.log(Level.FATAL, LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void fatal(String s, Object ... params) {
        this.log(Level.FATAL, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.log(Level.ERROR, LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.log(Level.ERROR, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void debug(String s, Object ... params) {
        this.log(Level.DEBUG, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void trace(String s, Object ... params) {
        this.log(Level.TRACE, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void warn(String s, Object ... params) {
        this.log(Level.WARN, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void info(String s, Object ... params) {
        this.log(Level.INFO, LogUtil.getLogInfo(s, params));
    }

    private void log(Level level, String content, Throwable throwable) {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
        String log = String.format("[%s] %s [] - %s", level, dateStr, content);
        if (level.isLessSpecificThan(Level.ERROR) && level.isMoreSpecificThan(Level.OFF)) {
            System.err.println(log);
        } else {
            System.out.println(log);
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
        }
    }

    private void log(Level level, String content) {
        this.log(level, content, null);
    }
}

