/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.jdbc;

import com.github.houbb.log.integration.adaptors.jdbc.BaseJdbcLogger;
import com.github.houbb.log.integration.adaptors.jdbc.ResultSetLogger;
import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.exception.LogException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;

public final class StatementLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private Statement statement;

    private StatementLogger(Statement stmt, Log statementLog, int queryStack) {
        super(statementLog, queryStack);
        this.statement = stmt;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws LogException {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, params);
            }
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug(" Executing: " + this.removeBreakingWhitespace((String)params[0]), true);
                }
                if ("executeQuery".equals(method.getName())) {
                    ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                    if (rs != null) {
                        return ResultSetLogger.newInstance(rs, this.statementLog, this.queryStack);
                    }
                    return null;
                }
                return method.invoke((Object)this.statement, params);
            }
            if ("getResultSet".equals(method.getName())) {
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs != null) {
                    return ResultSetLogger.newInstance(rs, this.statementLog, this.queryStack);
                }
                return null;
            }
            if ("equals".equals(method.getName())) {
                Object ps = params[0];
                return ps instanceof Proxy && proxy == ps;
            }
            if ("hashCode".equals(method.getName())) {
                return proxy.hashCode();
            }
            return method.invoke((Object)this.statement, params);
        }
        catch (Exception t) {
            throw new LogException(t);
        }
    }

    public static Statement newInstance(Statement stmt, Log statementLog, int queryStack) {
        StatementLogger handler = new StatementLogger(stmt, statementLog, queryStack);
        ClassLoader cl = Statement.class.getClassLoader();
        return (Statement)Proxy.newProxyInstance(cl, new Class[]{Statement.class}, (InvocationHandler)handler);
    }

    public Statement getStatement() {
        return this.statement;
    }
}

