/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.nlp.hanzi.similar.bs;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.nlp.hanzi.similar.api.IHanziData;
import com.github.houbb.nlp.hanzi.similar.api.IHanziSimilar;
import com.github.houbb.nlp.hanzi.similar.api.IHanziSimilarContext;
import com.github.houbb.nlp.hanzi.similar.core.HanziSimilar;
import com.github.houbb.nlp.hanzi.similar.support.data.HanziSimilarDatas;
import com.github.houbb.nlp.hanzi.similar.support.similar.HanziSimilarContext;
import com.github.houbb.nlp.hanzi.similar.support.similar.HanziSimilars;

public final class HanziSimilarBs {
    private double bihuashuRate = 2.0;
    private IHanziData<Integer> bihuashuData = HanziSimilarDatas.bihuashu();
    private IHanziSimilar bihuashuSimilar = HanziSimilars.bihuashu();
    private double jiegouRate = 10.0;
    private IHanziData<String> jiegouData = HanziSimilarDatas.jiegou();
    private IHanziSimilar jiegouSimilar = HanziSimilars.jiegou();
    private double bushouRate = 6.0;
    private IHanziData<String> bushouData = HanziSimilarDatas.bushou();
    private IHanziSimilar bushouSimilar = HanziSimilars.bushou();
    private double sijiaoRate = 8.0;
    private IHanziData<String> sijiaoData = HanziSimilarDatas.sijiao();
    private IHanziSimilar sijiaoSimilar = HanziSimilars.sijiao();
    private double pinyinRate = 1.0;
    private IHanziSimilar pinyinSimilar = HanziSimilars.pinyin();
    private double chaiziRate = 6.0;
    private IHanziSimilar chaiziSimilar = HanziSimilars.chaizi();
    private IHanziSimilar hanziSimilar = (IHanziSimilar)Instances.singleton(HanziSimilar.class);
    private IHanziData<Double> userDefineData = HanziSimilarDatas.userDefine();

    private HanziSimilarBs() {
    }

    public static HanziSimilarBs newInstance() {
        return new HanziSimilarBs();
    }

    public HanziSimilarBs bihuashuRate(double bihuashuRate) {
        ArgUtil.notNegative((double)bihuashuRate, (String)"bihuashuRate");
        this.bihuashuRate = bihuashuRate;
        return this;
    }

    public HanziSimilarBs bihuashuData(IHanziData<Integer> bihuashuData) {
        this.bihuashuData = bihuashuData;
        return this;
    }

    public HanziSimilarBs bihuashuSimilar(IHanziSimilar bihuashuSimilar) {
        this.bihuashuSimilar = bihuashuSimilar;
        return this;
    }

    public HanziSimilarBs jiegouRate(double jiegouRate) {
        ArgUtil.notNegative((double)jiegouRate, (String)"jiegouRate");
        this.jiegouRate = jiegouRate;
        return this;
    }

    public HanziSimilarBs jiegouData(IHanziData<String> jiegouData) {
        this.jiegouData = jiegouData;
        return this;
    }

    public HanziSimilarBs jiegouSimilar(IHanziSimilar jiegouSimilar) {
        this.jiegouSimilar = jiegouSimilar;
        return this;
    }

    public HanziSimilarBs bushouRate(double bushouRate) {
        ArgUtil.notNegative((double)bushouRate, (String)"bushouRate");
        this.bushouRate = bushouRate;
        return this;
    }

    public HanziSimilarBs bushouData(IHanziData<String> bushouData) {
        this.bushouData = bushouData;
        return this;
    }

    public HanziSimilarBs bushouSimilar(IHanziSimilar bushouSimilar) {
        this.bushouSimilar = bushouSimilar;
        return this;
    }

    public HanziSimilarBs sijiaoRate(double sijiaoRate) {
        ArgUtil.notNegative((double)sijiaoRate, (String)"sijiaoRate");
        this.sijiaoRate = sijiaoRate;
        return this;
    }

    public HanziSimilarBs sijiaoData(IHanziData<String> sijiaoData) {
        this.sijiaoData = sijiaoData;
        return this;
    }

    public HanziSimilarBs sijiaoSimilar(IHanziSimilar sijiaoSimilar) {
        this.sijiaoSimilar = sijiaoSimilar;
        return this;
    }

    public HanziSimilarBs pinyinRate(double pinyinRate) {
        ArgUtil.notNegative((double)pinyinRate, (String)"pinyinRate");
        this.pinyinRate = pinyinRate;
        return this;
    }

    public HanziSimilarBs pinyinSimilar(IHanziSimilar pinyinSimilar) {
        this.pinyinSimilar = pinyinSimilar;
        return this;
    }

    public HanziSimilarBs chaiziRate(double chaiziRate) {
        this.chaiziRate = chaiziRate;
        return this;
    }

    public HanziSimilarBs chaiziSimilar(IHanziSimilar chaiziSimilar) {
        this.chaiziSimilar = chaiziSimilar;
        return this;
    }

    public HanziSimilarBs hanziSimilar(IHanziSimilar hanziSimilar) {
        this.hanziSimilar = hanziSimilar;
        return this;
    }

    public HanziSimilarBs userDefineData(IHanziData<Double> userDefineData) {
        this.userDefineData = userDefineData;
        return this;
    }

    public double similar(char one, char two) {
        IHanziSimilarContext context = this.buildContext(one, two);
        return this.hanziSimilar.similar(context);
    }

    private IHanziSimilarContext buildContext(char one, char two) {
        HanziSimilarContext context = new HanziSimilarContext();
        context.charOne(one + "").charTwo(two + "").userDefineData(this.userDefineData).bihuashuData(this.bihuashuData).bihuashuSimilar(this.bihuashuSimilar).bihuashuRate(this.bihuashuRate).jiegouData(this.jiegouData).jiegouRate(this.jiegouRate).jiegouSimilar(this.jiegouSimilar).bushouData(this.bushouData).bushouSimilar(this.bushouSimilar).bushouRate(this.bushouRate).sijiaoData(this.sijiaoData).sijiaoRate(this.sijiaoRate).sijiaoSimilar(this.sijiaoSimilar).pinyinRate(this.pinyinRate).pinyinSimilar(this.pinyinSimilar).chaiziRate(this.chaiziRate).chaiziSimiar(this.chaiziSimilar);
        return context;
    }
}

