/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.nlp.hanzi.similar.support.similar;

import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.nlp.hanzi.similar.api.IHanziSimilar;
import com.github.houbb.nlp.hanzi.similar.api.IHanziSimilarContext;
import com.github.houbb.nlp.hanzi.similar.util.ChaiziHelper;
import java.util.List;
import java.util.Map;

public class ChaiziSimilar
implements IHanziSimilar {
    @Override
    public double similar(IHanziSimilarContext similarContext) {
        String hanziOne = similarContext.charOne();
        String hanziTwo = similarContext.charTwo();
        int numberOne = this.getNumber(hanziOne, similarContext);
        int numberTwo = this.getNumber(hanziTwo, similarContext);
        char[] charsOne = this.getSplitChars(hanziOne);
        char[] charsTwo = this.getSplitChars(hanziTwo);
        int minLen = Math.min(charsOne.length, charsTwo.length);
        double totalScore = 0.0;
        for (int i = 0; i < minLen; ++i) {
            char iChar = charsOne[i];
            String textChar = iChar + "";
            if (!ArrayPrimitiveUtil.contains((char[])charsTwo, (char)iChar)) continue;
            int textNumber = this.getNumber(textChar, similarContext);
            double scoreOne = (double)textNumber * 1.0 / (double)numberOne * 1.0;
            double scoreTwo = (double)textNumber * 1.0 / (double)numberTwo * 1.0;
            totalScore += (scoreOne + scoreTwo) / 2.0;
        }
        return totalScore * similarContext.chaiziRate();
    }

    private char[] getSplitChars(String charWord) {
        List stringList = ChaiziHelper.chai((char)charWord.charAt(0));
        String string = (String)stringList.get(0);
        return string.toCharArray();
    }

    private int getNumber(String text, IHanziSimilarContext similarContext) {
        Map<String, Integer> map = similarContext.bihuashuData().dataMap();
        Integer number = map.get(text);
        if (number == null) {
            return 1;
        }
        return number;
    }
}

