/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.nlp.hanzi.similar.support.similar;

import com.github.houbb.nlp.hanzi.similar.api.IHanziSimilar;
import com.github.houbb.nlp.hanzi.similar.api.IHanziSimilarContext;

public class SijiaoSimilar
implements IHanziSimilar {
    @Override
    public double similar(IHanziSimilarContext similarContext, String charOne, String charTwo) {
        String codeOne = similarContext.sijiaoData().dataMap().get(charOne);
        String codeTwo = similarContext.sijiaoData().dataMap().get(charTwo);
        if (codeOne != null && codeTwo != null) {
            double score = this.calcScore(codeOne, codeTwo);
            return score * similarContext.sijiaoRate();
        }
        return 0.0;
    }

    private double calcScore(String codeOne, String codeTwo) {
        if (codeOne.length() == codeTwo.length()) {
            int len = codeOne.length();
            if (len <= 0) {
                return 0.0;
            }
            int total = 0;
            for (int i = 0; i < len; ++i) {
                if (codeOne.charAt(i) != codeTwo.charAt(i)) continue;
                ++total;
            }
            return (double)total * 1.0 / ((double)len * 1.0);
        }
        return 0.0;
    }
}

