/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.util;

import com.github.houbb.opencc4j.exception.Opencc4jRuntimeException;
import com.github.houbb.paradise.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public final class DataFileUtil {
    private static Map<String, String> S2T_CHAR_MAP;
    private static Map<String, String> S2T_PHASE_MAP;
    private static Map<String, String> T2S_CHAR_MAP;
    private static Map<String, String> T2S_PHASE_MAP;

    private DataFileUtil() {
    }

    private static Map<String, String> buildDataMap(String path) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            InputStream is = DataFileUtil.class.getResourceAsStream(path);
            BufferedReader e = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            while (e.ready()) {
                String entry = e.readLine();
                if (StringUtil.isEmpty((String)entry)) continue;
                String[] strings = StringUtil.splitByAnyBlank((String)entry);
                map.put(strings[0], strings[1]);
            }
            return map;
        }
        catch (IOException e) {
            throw new Opencc4jRuntimeException("Dict \u6570\u636e\u52a0\u8f7d\u5931\u8d25!", e);
        }
    }

    public static String getS2TResult(String original) {
        return DataFileUtil.getPhaseResult(original, S2T_PHASE_MAP, S2T_CHAR_MAP);
    }

    public static String getT2SResult(String original) {
        return DataFileUtil.getPhaseResult(original, T2S_PHASE_MAP, T2S_CHAR_MAP);
    }

    private static String getPhaseResult(String original, Map<String, String> phraseMap, Map<String, String> charMap) {
        String phrase = phraseMap.get(original);
        if (StringUtil.isNotEmpty((String)phrase) && !"\ud86d\uddf5".equals(phrase)) {
            return phrase;
        }
        char[] chars = original.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : chars) {
            String result = DataFileUtil.getCharResult(Character.toString(c), charMap);
            stringBuilder.append(result);
        }
        return stringBuilder.toString();
    }

    private static String getCharResult(String original, Map<String, String> charMap) {
        String c = charMap.get(original);
        if (StringUtil.isNotEmpty((String)c) && !"\ud86d\uddf5".equals(c)) {
            return c;
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<DataFileUtil> clazz = DataFileUtil.class;
        synchronized (DataFileUtil.class) {
            S2T_CHAR_MAP = DataFileUtil.buildDataMap("/data/dictionary/STCharacters.txt");
            S2T_PHASE_MAP = DataFileUtil.buildDataMap("/data/dictionary/STPhrases.txt");
            T2S_CHAR_MAP = DataFileUtil.buildDataMap("/data/dictionary/TSCharacters.txt");
            T2S_PHASE_MAP = DataFileUtil.buildDataMap("/data/dictionary/TSPhrases.txt");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

