/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.support.instance.impl;

import com.github.houbb.opencc4j.annotation.ThreadSafe;
import com.github.houbb.opencc4j.exception.Opencc4jRuntimeException;
import com.github.houbb.opencc4j.support.instance.Instance;
import com.github.houbb.opencc4j.util.ArgUtil;
import com.github.houbb.opencc4j.util.ObjectUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ThreadSafe
public final class InstanceFactory
implements Instance {
    private final Map<String, Object> singletonMap = new ConcurrentHashMap<String, Object>();
    private ThreadLocal<Map<String, Object>> mapThreadLocal = new ThreadLocal();

    private InstanceFactory() {
    }

    public static InstanceFactory getInstance() {
        return SingletonHolder.INSTANCE_FACTORY;
    }

    @Override
    public <T> T singleton(Class<T> tClass) {
        this.notNull(tClass);
        return this.getSingleton(tClass, this.singletonMap);
    }

    @Override
    public <T> T threadLocal(Class<T> tClass) {
        this.notNull(tClass);
        Map<String, Object> map = this.mapThreadLocal.get();
        if (ObjectUtil.isNull(map)) {
            map = new ConcurrentHashMap<String, Object>();
        }
        T instance = this.getSingleton(tClass, map);
        this.mapThreadLocal.set(map);
        return instance;
    }

    @Override
    public <T> T multiple(Class<T> tClass) {
        this.notNull(tClass);
        try {
            return tClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new Opencc4jRuntimeException(e);
        }
    }

    private <T> T getSingleton(Class<T> tClass, Map<String, Object> instanceMap) {
        this.notNull(tClass);
        String fullClassName = tClass.getName();
        Object instance = instanceMap.get(fullClassName);
        if (ObjectUtil.isNull(instance)) {
            instance = this.multiple(tClass);
            instanceMap.put(fullClassName, instance);
        }
        return (T)instance;
    }

    private void notNull(Class tClass) {
        ArgUtil.notNull(tClass, "class");
    }

    private static class SingletonHolder {
        private static final InstanceFactory INSTANCE_FACTORY = new InstanceFactory();

        private SingletonHolder() {
        }
    }
}

