/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.support.match.impl;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.opencc4j.core.ZhConvertCoreContext;
import com.github.houbb.opencc4j.support.datamap.IDataMap;
import com.github.houbb.opencc4j.support.match.ZhMatch;
import com.github.houbb.opencc4j.util.InnerCharUtils;
import java.util.List;

public abstract class AbstractZhMatch
implements ZhMatch {
    protected abstract boolean doMatch(String var1, List<String> var2, ZhConvertCoreContext var3);

    @Override
    public boolean match(String text, ZhConvertCoreContext context) {
        if (StringUtil.isEmpty((String)text)) {
            return false;
        }
        List<String> chars = context.zhChars().chars(text);
        return this.doMatch(text, chars, context);
    }

    protected boolean isChinese(String charSeg, ZhConvertCoreContext context) {
        if (StringUtil.isEmpty((String)charSeg)) {
            return false;
        }
        return InnerCharUtils.isChineseForSingle(charSeg);
    }

    protected boolean isTraditional(String charSeg, ZhConvertCoreContext context) {
        if (!this.isChinese(charSeg, context)) {
            return false;
        }
        IDataMap dataMap = context.dataMap();
        return dataMap.tChars().contains(charSeg);
    }

    protected boolean isSimple(String charSeg, ZhConvertCoreContext context) {
        if (!this.isChinese(charSeg, context)) {
            return false;
        }
        IDataMap dataMap = context.dataMap();
        return dataMap.sChars().contains(charSeg);
    }
}

