/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.core.impl;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.opencc4j.core.ZhConvert;
import com.github.houbb.opencc4j.core.ZhConvertCore;
import com.github.houbb.opencc4j.core.ZhConvertCoreContext;
import com.github.houbb.opencc4j.core.impl.ZhConvertCoreDefault;
import com.github.houbb.opencc4j.support.chars.ZhChar;
import com.github.houbb.opencc4j.support.chars.ZhChars;
import com.github.houbb.opencc4j.support.convert.core.UnitConvert;
import com.github.houbb.opencc4j.support.convert.core.UnitConverts;
import com.github.houbb.opencc4j.support.datamap.IDataMap;
import com.github.houbb.opencc4j.support.datamap.impl.DataMaps;
import com.github.houbb.opencc4j.support.match.ZhMatch;
import com.github.houbb.opencc4j.support.match.ZhMatches;
import com.github.houbb.opencc4j.support.segment.Segment;
import com.github.houbb.opencc4j.support.segment.impl.Segments;
import java.util.List;

public class ZhConvertBootstrap
implements ZhConvert {
    private Segment segment = Segments.defaults();
    private IDataMap dataMap = DataMaps.defaults();
    private ZhChar zhChar = ZhChars.defaults();
    private UnitConvert unitConvert = UnitConverts.defaults();
    private ZhConvertCore zhConvertCore = new ZhConvertCoreDefault();
    private ZhMatch isSimpleMatch = ZhMatches.simpleAll();
    private ZhMatch isTraditionalMatch = ZhMatches.traditionalAll();
    private ZhConvertCoreContext context;

    private ZhConvertBootstrap() {
    }

    public static ZhConvertBootstrap newInstance() {
        return new ZhConvertBootstrap();
    }

    @Deprecated
    public static ZhConvertBootstrap newInstance(Segment segment) {
        ZhConvertBootstrap bs = ZhConvertBootstrap.newInstance();
        bs.segment(segment);
        return bs;
    }

    public ZhConvertBootstrap segment(Segment segment) {
        ArgUtil.notNull((Object)segment, (String)"segment");
        this.segment = segment;
        return this;
    }

    public ZhConvertBootstrap dataMap(IDataMap dataMap) {
        ArgUtil.notNull((Object)dataMap, (String)"dataMap");
        this.dataMap = dataMap;
        return this;
    }

    public ZhConvertBootstrap zhChar(ZhChar zhChar) {
        ArgUtil.notNull((Object)zhChar, (String)"zhChar");
        this.zhChar = zhChar;
        return this;
    }

    public ZhConvertBootstrap unitConvert(UnitConvert unitConvert) {
        ArgUtil.notNull((Object)unitConvert, (String)"unitConvert");
        this.unitConvert = unitConvert;
        return this;
    }

    public ZhConvertBootstrap isSimpleMatch(ZhMatch isSimpleMatch) {
        ArgUtil.notNull((Object)isSimpleMatch, (String)"isSimpleMatch");
        this.isSimpleMatch = isSimpleMatch;
        return this;
    }

    public ZhConvertBootstrap isTraditionalMatch(ZhMatch isTraditionalMatch) {
        ArgUtil.notNull((Object)isTraditionalMatch, (String)"isTraditionalMatch");
        this.isTraditionalMatch = isTraditionalMatch;
        return this;
    }

    public ZhConvertBootstrap init() {
        this.context = ZhConvertCoreContext.newInstance().zhChars(this.zhChar).segment(this.segment).unitConvert(this.unitConvert).dataMap(this.dataMap).isSimpleMatch(this.isSimpleMatch).isTraditionalMatch(this.isTraditionalMatch);
        return this;
    }

    @Override
    public String toSimple(String original) {
        return this.zhConvertCore.toSimple(original, this.context);
    }

    @Override
    public String toTraditional(String original) {
        return this.zhConvertCore.toTraditional(original, this.context);
    }

    @Override
    @Deprecated
    public List<String> doSeg(String original) {
        if (StringUtil.isEmpty((String)original)) {
            return Guavas.newArrayList();
        }
        return this.segment.seg(original);
    }

    @Override
    public List<String> simpleList(String original) {
        return this.zhConvertCore.simpleList(original, this.context);
    }

    @Override
    public List<String> traditionalList(String original) {
        return this.zhConvertCore.traditionalList(original, this.context);
    }

    @Override
    public boolean isSimple(char c) {
        return this.zhConvertCore.isSimple(c, this.context);
    }

    @Override
    public boolean isSimple(String charOrPhrase) {
        return this.zhConvertCore.isSimple(charOrPhrase, this.context);
    }

    @Override
    public boolean containsSimple(String charOrPhrase) {
        return this.zhConvertCore.containsSimple(charOrPhrase, this.context);
    }

    @Override
    public boolean isTraditional(char c) {
        return this.zhConvertCore.isTraditional(c, this.context);
    }

    @Override
    public boolean isTraditional(String charOrPhrase) {
        return this.zhConvertCore.isTraditional(charOrPhrase, this.context);
    }

    @Override
    public boolean containsTraditional(String charOrPhrase) {
        return this.zhConvertCore.containsTraditional(charOrPhrase, this.context);
    }

    @Override
    public boolean isChinese(char c) {
        return this.zhConvertCore.isChinese(c, this.context);
    }

    @Override
    public boolean isChinese(String charOrPhrase) {
        return this.zhConvertCore.isChinese(charOrPhrase, this.context);
    }

    @Override
    public boolean containsChinese(String charOrPhrase) {
        return this.zhConvertCore.containsChinese(charOrPhrase, this.context);
    }

    @Override
    public List<String> toSimple(char c) {
        return this.zhConvertCore.toSimple(c, this.context);
    }

    @Override
    public List<String> toTraditional(char c) {
        return this.zhConvertCore.toTraditional(c, this.context);
    }
}

