/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.paradise.enhance.core.translator.impl;

import com.github.houbb.paradise.enhance.constant.translator.GoogleLanguageEnum;
import com.github.houbb.paradise.enhance.core.translator.Translator;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class GoogleTranslator
implements Translator<String> {
    private String text;
    private String srcLang;
    private String targetLang;

    public GoogleTranslator(String text, String srcLang, String targetLang) {
        this.text = text;
        this.srcLang = srcLang;
        this.targetLang = targetLang;
    }

    public GoogleTranslator(String text, String targetLang) {
        this(text, "", targetLang);
    }

    public static GoogleTranslator newInstance(String text, String srcLang, String targetLang) {
        return new GoogleTranslator(text, srcLang, targetLang);
    }

    public static GoogleTranslator newInstance(String text, String targetLang) {
        return new GoogleTranslator(text, "", targetLang);
    }

    @Override
    public String translate() throws Exception {
        return this.execute(this.text, this.srcLang, this.targetLang);
    }

    public String translateOrDefault(String defaultVal) {
        try {
            return this.translate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultVal;
        }
    }

    public String[] translate(String[] texts, String srcLang, String targetLang) throws Exception {
        StringBuilder content = new StringBuilder();
        int size = texts.length;
        for (int i = 0; i < size; ++i) {
            if (i < size - 1) {
                content.append(texts[i]).append("{*}");
                continue;
            }
            content.append(texts[i]);
        }
        String[] temps = this.execute(content.toString(), srcLang, targetLang).split("\\{\\*\\}");
        size = temps.length;
        for (int i = 0; i < size; ++i) {
            temps[i] = temps[i].trim();
        }
        return temps;
    }

    private String execute(String text, String srcLang, String targetLang) throws Exception {
        Document document = Jsoup.connect((String)"https://translate.google.cn/").data("sl", srcLang).data("ie", "UTF-8").data("oe", "UTF-8").data("text", text).data("tl", targetLang).userAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36").cookie("Cookie", "NID=101=IxXmFpFshaY43MPgpE-1LlE-CJUDmXHXaXk-yN13vShZ0VwfJb8AOefXmeRmfGWW3-56oCWYPQDXqcKNRrIuEubTZV4ZpO8nL6F1PZPDE0ILUVGzZuMxhNfarad0TM5-; _ga=GA1.3.109626246.1492094023").timeout(2000000).get();
        Element element = document.getElementById("result_box");
        return element.text();
    }

    public static void main(String[] args) {
        String text = "\u4f60\u4eca\u5929\u771f\u597d\u770b";
        GoogleTranslator translate = new GoogleTranslator(text, GoogleLanguageEnum.ENGLISH.langInfo());
        try {
            System.out.println(translate.translate());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

