/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.support.chinese;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.CharUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CharsetUtil;
import com.github.houbb.nlp.common.format.impl.CharFormats;
import com.github.houbb.pinyin.spi.IPinyinChinese;

@ThreadSafe
public class SimplePinyinChinese
implements IPinyinChinese {
    @Override
    public boolean isChinese(String original) {
        return CharsetUtil.isAllChinese((String)original);
    }

    @Override
    public boolean isChinese(char original) {
        return CharUtil.isChinese((char)original);
    }

    @Override
    public String toSimple(String segment) {
        if (StringUtil.isEmptyTrim((String)segment)) {
            return segment;
        }
        char[] chars = segment.toCharArray();
        StringBuilder buffer = new StringBuilder(segment.length());
        for (char c : chars) {
            if (CharsetUtil.isChinese((char)c)) {
                char simpleChar = CharFormats.chineseSimple().format(c);
                buffer.append(simpleChar);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @Override
    public String toSimple(char original) {
        if (this.isChinese(original)) {
            char simpleChar = CharFormats.chineseSimple().format(original);
            return String.valueOf(simpleChar);
        }
        return String.valueOf(original);
    }
}

