/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.pinyin.util;

import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.pinyin.bs.PinyinBs;
import com.github.houbb.pinyin.constant.enums.PinyinStyleEnum;
import com.github.houbb.pinyin.spi.IPinyinToneStyle;
import com.github.houbb.pinyin.support.style.PinyinToneStyles;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PinyinHelper {
    private static final PinyinBs PINYIN_BS_DEFAULT = PinyinBs.newInstance().init();

    private PinyinHelper() {
    }

    public static String toPinyin(String string) {
        return PINYIN_BS_DEFAULT.toPinyin(string);
    }

    public static String toPinyin(String string, PinyinStyleEnum styleEnum) {
        return PinyinHelper.toPinyin(string, styleEnum, " ");
    }

    public static String toPinyin(String string, PinyinStyleEnum styleEnum, String connector) {
        ArgUtil.notNull((Object)connector, (String)"connector");
        if (StringUtil.isEmptyTrim((String)string)) {
            return string;
        }
        IPinyinToneStyle style = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(style).connector(connector).init().toPinyin(string);
    }

    public static List<String> toPinyinList(char chinese) {
        return PINYIN_BS_DEFAULT.toPinyinList(chinese);
    }

    public static List<String> toPinyinList(char chinese, PinyinStyleEnum styleEnum) {
        IPinyinToneStyle pinyinTone = PinyinToneStyles.getTone(styleEnum);
        return PinyinBs.newInstance().style(pinyinTone).init().toPinyinList(chinese);
    }

    public static boolean hasSamePinyin(char chineseOne, char chineseTwo) {
        return PINYIN_BS_DEFAULT.hasSamePinyin(chineseOne, chineseTwo);
    }

    public static Map<String, List<String>> samePinyinMap(char hanzi) {
        List<String> pinyinList = PinyinHelper.toPinyinList(hanzi, PinyinStyleEnum.NUM_LAST);
        if (CollectionUtil.isEmpty(pinyinList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>(pinyinList.size());
        for (String pinyin : pinyinList) {
            List<String> characterList = PinyinHelper.samePinyinList(pinyin);
            map.put(pinyin, characterList);
        }
        return map;
    }

    public static List<String> samePinyinList(String pinyinNumLast) {
        boolean sameTone = true;
        return PINYIN_BS_DEFAULT.samePinyinList(pinyinNumLast, true);
    }
}

