package com.github.houbb.property.annotation;

import java.lang.annotation.*;

/**
 * 属性明细注解
 * （1）暂时只支持用户自定义对象属性
 * （2）被这个注解指定之后，默认忽略 {@link PropertyField} 字段注解。
 * （3）如果指定的字段为集合/列表，会直接报错。
 * 如果字段不是对象，也直接报错。
 *
 * @author binbin.hou
 * @since 0.0.4
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface PropertyEntry {

    /**
     * 属性别称
     * @return 别称
     * @since 0.0.4
     */
    String value() default "";

}
