package com.github.houbb.property.annotation;

import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.impl.DefaultValueConverter;

import java.lang.annotation.*;

/**
 * 属性字段注解
 * @author binbin.hou
 * @since 0.0.2
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface PropertyField {

    /**
     * 属性别称
     * @return 别称
     * @since 0.0.2
     */
    String value() default "";

    /**
     * 字段转换类
     * @return 结果
     * @since 0.0.2
     */
    Class<? extends IValueConverter> converter() default DefaultValueConverter.class;

}
