package com.github.houbb.property.annotation;

import com.github.houbb.property.constant.format.DateFormatConst;
import com.github.houbb.property.constant.format.DecimalFormatConst;

import java.lang.annotation.*;
import java.util.Date;

/**
 * 格式化注解
 *
 * @author binbin.hou
 * @since 0.0.6
 * @see java.util.Date 日期
 * @see java.math.BigDecimal 金额
 * @see Long 长整形
 * @see Double 浮点型
 * @see java.text.NumberFormat#format(Object) 数字格式化
 * @see java.text.DateFormat#format(Object) 日期格式化
 */
@Documented
@Inherited
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface PropertyFormat {

    /**
     * 属性格式化
     * @return 格式化
     * @see DateFormatConst 日期格式化常量
     * @see DecimalFormatConst 数字格式化常量
     * @since 0.0.6
     */
    String value() default "";

}
