package com.github.houbb.property.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

/**
 * 配置读取接口
 * @author binbin.hou
 * @since 0.0.8
 */
public interface IPropertyReader {

    /**
     * 获取对应的值
     *
     * @param key 指定的 key
     * @return 结果
     * @since 0.0.8
     */
    String get(final String key);

    /**
     * 获取对应的值或者默认值
     *
     * @param key 指定的 key
     * @param defaultVal 默认的值，如果原始值为 null,则返回
     * @return 结果
     * @since 0.0.8
     */
    String getOrDefault(final String key, final String defaultVal);

    /**
     * 返回 boolean 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Boolean getBool(final String key);

    /**
     * 返回 byte 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Byte getByte(final String key);

    /**
     * 返回 char 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Character getChar(final String key);

    /**
     * 返回 short 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Short getShort(final String key);

    /**
     * 返回 Integer 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Integer getInt(final String key);

    /**
     * 返回 Long 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Long getLong(final String key);

    /**
     * 返回 Float 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Float getFloat(final String key);

    /**
     * 返回 Double 值
     * @param key 键
     * @return 返回值
     * @since 0.0.8
     */
    Double getDouble(final String key);

    /**
     * 获取日期
     * @param key 键
     * @param dateFormat 格式
     * @return 结果
     * @since 0.0.8
     */
    Date getDate(final String key, final String dateFormat);

    /**
     * 获取日期
     *
     * 默认的格式: yyyyMMdd
     * @param key 键
     * @return 结果
     * @since 0.0.8
     */
    Date getDate(final String key);

    /**
     * 获取 BigInteger
     * @param key 键
     * @return 结果
     * @since 0.0.8
     */
    BigInteger getBigInteger(final String key);

    /**
     * 获取 BigDecimal
     * @param key 键
     * @return 结果
     * @since 0.0.8
     */
    BigDecimal getBigDecimal(final String key);

}
