package com.github.houbb.property.constant.format;

/**
 * 日期格式化常量
 * @author binbin.hou
 * @since 0.0.6
 */
public final class DateFormatConst {

    private DateFormatConst(){}


    /**
     * 纯净日期格式化
     * @since 0.0.6
     */
    public static final String PURE_DATE_FORMAT = "yyyyMMdd";

    /**
     * 日期格式化
     * @since 0.0.6
     */
    public static final String DATE_FORMAT = "yyyy-MM-dd";

    /**
     * 纯净时间格式化
     * @since 0.0.6
     */
    public static final String PURE_TIME_FORMAT = "HHmmss";

    /**
     * 时间格式化
     * @since 0.0.6
     */
    public static final String TIME_FORMAT = "HH:mm:ss";

    /**
     * 简单的日期时间格式化
     * @since 0.0.6
     */
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    /**
     * 时间戳格式化
     * 17位长度
     */
    public static final String TIMESTAMP_FORMAT_17 = "yyyyMMddHHmmssSSS";

    /**
     * 时间戳格式化(15 位长度)
     * 备注：因为 2019 最前面两位，在自己的有生之年，基本是不变的。
     * @since 0.0.6
     */
    public static final String TIMESTAMP_FORMAT_15 = "yyMMddHHmmssSSS";

}
