package com.github.houbb.property.constant.format;

/**
 * 数字格式化常量
 * （1）左右补0
 * （2）小数位数
 * （3）开头信息 ￥$
 * （4）逗号分隔 ,
 *
 *  特殊字符说明
 *
 * <pre>
 * 0 指定位置不存在数字则显示为0 123.123 + 0000.0000 = 0123.1230
 * # 指定位置不存在数字则不显示 123.123 + ####.#### = 123.123
 * . 小数点
 * % 会将结果数字乘以100 后面再加上% 123.123 + #.00 = 1.3212%
 * </pre>
 *
 * 参考资料：
 *
 * [DecimalFormat](https://docs.oracle.com/javase/7/docs/api/java/text/DecimalFormat.html)
 * [java中decimalFormat格式化数值](https://www.cnblogs.com/zhaod/p/8811093.html)
 *
 * @author binbin.hou
 * @since 0.0.6
 */
public final class DecimalFormatConst {

    private DecimalFormatConst(){}



}
