package com.github.houbb.property.core;

import com.github.houbb.heaven.support.attr.IAttributeContext;
import com.github.houbb.heaven.util.lang.StringUtil;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

/**
 * 属性接口类
 *
 * @author binbin.hou
 * @since 0.0.1
 */
public interface IProperty extends IAttributeContext {

    /**
     * 从指定路径加载文件信息
     * （1）允许多次执行
     * （2）允许指定不同的文件信息
     * @param inputStream 输入流
     * @param charset 字符集
     * @return this
     * @since 0.0.1
     */
    IProperty load(final InputStream inputStream, final String charset);

    /**
     * 向指定路径刷新文件信息
     * （1）允许多次执行
     * （2）允许指定不同的文件信息
     * @param outputStream 输出流
     * @param charset 字符集
     * @return this
     * @since 0.0.1
     */
    IProperty flush(final OutputStream outputStream, final String charset);

    /**
     * 设置一个 map 属性
     * @param map map
     * @return this
     * @since 0.0.2
     */
    IProperty putAttr(Map<String, String> map);

    /**
     * 转换为 map
     * （1）是属性的一次拷贝，不会影响原来的属性信息。
     * @return map
     * @since 0.0.2
     */
    Map<String, String> asMap();

    /**
     * 转换为配置
     * @return 转换为配置文件
     * @since 0.0.8
     */
    public Properties asProperties();

}
