package com.github.houbb.property.model;

import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.annotation.PropertyField;
import com.github.houbb.property.annotation.PropertyFormat;
import com.github.houbb.property.support.converter.IValueConverter;

import java.lang.reflect.Field;

/**
 * 属性对象
 * @author binbin.hou
 * @since 0.0.2
 */
public class PropertyBo {

    /**
     * 主题对象信息
     * @since 0.0.2
     */
    private Object object;

    /**
     * 字段信息
     * @since 0.0.2
     */
    private Field field;

    /**
     * 属性字段注解
     * @since 0.0.2
     */
    private PropertyField propertyField;

    /**
     * 字段名称
     * @since 0.0.2
     */
    private String fieldName;

    /**
     * 属性名称
     * @since 0.0.2
     */
    private String propertyName;

    /**
     * 转换类实现
     * @since 0.0.2
     */
    private IValueConverter converter;

    /**
     * 注解明细信息
     * @since 0.0.4
     */
    private PropertyEntry propertyEntry;

    /**
     * 父类对象
     * @since 0.0.4
     */
    private Object parentObject;

    /**
     * 属性格式化
     * @since 0.0.6
     */
    private PropertyFormat propertyFormat;

    /**
     * 格式化信息
     * @since 0.0.6
     */
    private String format;

    /**
     * 新建一个对象实例
     * @return 对象实例
     * @since 0.0.2
     */
    public static PropertyBo newInstance() {
        return new PropertyBo();
    }

    public Object object() {
        return object;
    }

    public PropertyBo object(Object object) {
        this.object = object;
        return this;
    }

    public Field field() {
        return field;
    }

    public PropertyBo field(Field field) {
        this.field = field;
        return this;
    }

    public PropertyField propertyField() {
        return propertyField;
    }

    public PropertyBo propertyField(PropertyField propertyField) {
        this.propertyField = propertyField;
        return this;
    }

    public String fieldName() {
        return fieldName;
    }

    public PropertyBo fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public String propertyName() {
        return propertyName;
    }

    public PropertyBo propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public IValueConverter converter() {
        return converter;
    }

    public PropertyBo converter(IValueConverter converter) {
        this.converter = converter;
        return this;
    }

    public PropertyEntry propertyEntry() {
        return propertyEntry;
    }

    public PropertyBo propertyEntry(PropertyEntry propertyEntry) {
        this.propertyEntry = propertyEntry;
        return this;
    }

    public Object parentObject() {
        return parentObject;
    }

    public PropertyBo parentObject(Object parentObject) {
        this.parentObject = parentObject;
        return this;
    }

    public PropertyFormat propertyFormat() {
        return propertyFormat;
    }

    public PropertyBo propertyFormat(PropertyFormat propertyFormat) {
        this.propertyFormat = propertyFormat;
        return this;
    }

    public String format() {
        return format;
    }

    public PropertyBo format(String format) {
        this.format = format;
        return this;
    }

}
