package com.github.houbb.property.support.bean.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.constant.PunctuationConst;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.model.PropertyBo;
import com.github.houbb.property.support.bean.IBeanToMap;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.context.PropertyValueContext;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * <p> project: property-IBeanToMap </p>
 * <p> create on 2019/11/20 20:20 </p>
 *
 * @author Administrator
 * @since 0.0.4
 * @see com.github.houbb.property.annotation.PropertyEntry 明细信息
 */
@ThreadSafe
public class BeanToMap implements IBeanToMap {

    /**
     * 对象转 map
     *
     * @param bean 对象
     * @return map
     * @since 0.0.4
     */
    @Override
    public Map<String, String> beanToMap(final Object bean) {
        Map<String, String> valueMap = Guavas.newHashMap();
        this.beanToMapWithEntry(StringUtil.EMPTY, bean, valueMap);
        return valueMap;
    }

    /**
     * bean 转化为 map
     * （1）支持 {@link PropertyEntry} 属性指定
     * @param prefix 前缀
     * @param bean 对象属性
     * @param valueMap map 集合
     * @since 0.0.4
     */
    private void beanToMapWithEntry(final String prefix, final Object bean,
                                    final Map<String, String> valueMap) {
        Map<String, PropertyBo> propertyBoMap = PropertyBos.buildPropertyBoMap(bean);
        if (MapUtil.isEmpty(propertyBoMap)) {
            return;
        }

        // 构建转换上下文
        for (Map.Entry<String, PropertyBo> entry : propertyBoMap.entrySet()) {
            // 添加属性前缀
            final String propertyName = prefix + entry.getKey();
            final PropertyBo propertyBo = entry.getValue();
            final Field field = propertyBo.field();
            final Object fieldValue = ReflectFieldUtil.getValue(field, bean);

            // 指定了属性，则进行递归处理
            final PropertyEntry propertyEntry = propertyBo.propertyEntry();
            if(ObjectUtil.isNotNull(propertyEntry)) {
                final String prefixNew = propertyName + PunctuationConst.DOT;
                this.beanToMapWithEntry(prefixNew, fieldValue, valueMap);
            } else {
                // 正常处理字段信息
                final PropertyValueContext context = PropertyValueContext.newInstance();
                context.field(field)
                        .fieldName(propertyBo.fieldName())
                        .propertyName(propertyName)
                        .object(bean)
                        .propertyField(propertyBo.propertyField())
                        .propertyFormat(propertyBo.propertyFormat())
                        .format(propertyBo.format());


                final IValueConverter converter = propertyBo.converter();
                String propertyValue = converter.propertyValue(fieldValue, context);
                valueMap.put(propertyName, propertyValue);
            }
        }
    }

}
