package com.github.houbb.property.support.bean.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.constant.PunctuationConst;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.model.PropertyBo;
import com.github.houbb.property.support.bean.IBeanToMap;
import com.github.houbb.property.support.bean.IMapToBean;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.context.FieldValueContext;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * <p> project: property-IBeanToMap </p>
 * <p> create on 2019/11/20 20:20 </p>
 *
 * @author Administrator
 * @since 0.0.4
 */
@ThreadSafe
public class MapToBean implements IMapToBean {

    @Override
    public void mapToBean(Map<String, String> valueMap, Object bean) {
        if (MapUtil.isEmpty(valueMap)) {
            return;
        }

        this.mapToBeanWithEntry(StringUtil.EMPTY, valueMap, bean);
    }

    /**
     * map 转换为 bean，拥有明细信息
     * @param prefix 前缀
     * @param valueMap 值集合
     * @param bean 对象属性
     * @since 0.0.4
     */
    private void mapToBeanWithEntry(final String prefix,
                                    final Map<String, String> valueMap, Object bean) {
        Map<String, PropertyBo> propertyBoMap = PropertyBos.buildPropertyBoMap(bean);
        //fast-fail
        if (MapUtil.isEmpty(propertyBoMap)) {
            return;
        }

        // 遍历处理
        for (Map.Entry<String, PropertyBo> entry : propertyBoMap.entrySet()) {
            final String propertyName = prefix + entry.getKey();
            final PropertyBo propertyBo = entry.getValue();
            final Field field = propertyBo.field();
            final Class fieldType = field.getType();

            final PropertyEntry propertyEntry = propertyBo.propertyEntry();
            if(ObjectUtil.isNotNull(propertyEntry)) {
                final String prefixNew = propertyName + PunctuationConst.DOT;
                Object fieldValue = ClassUtil.newInstance(fieldType);
                mapToBeanWithEntry(prefixNew, valueMap, fieldValue);
                ReflectFieldUtil.setValue(field, bean, fieldValue);
            } else {
                // 正常处理逻辑
                if (valueMap.containsKey(propertyName)) {
                    final String value = valueMap.get(propertyName);
                    IValueConverter converter = propertyBo.converter();

                    FieldValueContext context = FieldValueContext.newInstance();
                    context.field(field)
                            .fieldName(propertyBo.fieldName())
                            .propertyName(propertyName)
                            .object(bean)
                            .propertyField(propertyBo.propertyField())
                            .propertyFormat(propertyBo.propertyFormat())
                            .format(propertyBo.format());

                    Object fieldValue = converter.fieldValue(value, context);
                    ReflectFieldUtil.setValue(field, bean, fieldValue);
                }
            }
        }
    }

}
