package com.github.houbb.property.support.bean.impl;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.annotation.PropertyField;
import com.github.houbb.property.annotation.PropertyFormat;
import com.github.houbb.property.model.PropertyBo;
import com.github.houbb.property.support.converter.IValueConverter;
import com.github.houbb.property.support.converter.factory.ValueConverterFactory;
import com.github.houbb.property.support.converter.impl.DefaultValueConverter;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * 属性工具类
 * <p> project: property-PropertyBos </p>
 * <p> create on 2019/11/20 20:24 </p>
 *
 * @author Administrator
 * @since 0.0.4
 */
final class PropertyBos {

    /**
     * 私有化构造器
     * @since 0.0.6
     */
    private PropertyBos(){}

    /**
     * 构建属性 bo Map
     *
     * @param bean 对象信息
     * @return map 信息
     * @since 0.0.2
     */
    static Map<String, PropertyBo> buildPropertyBoMap(final Object bean) {
        if (ObjectUtil.isNull(bean)) {
            return Guavas.newHashMap();
        }

        // 设置属性
        Map<String, Field> fieldMap = ClassUtil.getAllFieldMap(bean.getClass());
        if (MapUtil.isEmpty(fieldMap)) {
            return Guavas.newHashMap();
        }

        Map<String, PropertyBo> resultMap = Guavas.newHashMap(fieldMap.size());
        for (Map.Entry<String, Field> entry : fieldMap.entrySet()) {
            final String fieldName = entry.getKey();
            final Field field = entry.getValue();
            String propertyName = fieldName;
            Class<? extends IValueConverter> converterClass = DefaultValueConverter.class;
            PropertyField propertyField = null;

            if (field.isAnnotationPresent(PropertyField.class)) {
                propertyField = field.getAnnotation(PropertyField.class);

                String value = propertyField.value();
                if (StringUtil.isNotEmpty(value)) {
                    propertyName = value;
                }
                converterClass = propertyField.converter();
            }

            PropertyEntry propertyEntry = null;
            if(field.isAnnotationPresent(PropertyEntry.class)) {
                propertyEntry = field.getAnnotation(PropertyEntry.class);

                String value = propertyEntry.value();
                if(StringUtil.isNotEmpty(value)) {
                    propertyName = value;
                }
            }

            PropertyFormat propertyFormat = null;
            String format = null;
            if(field.isAnnotationPresent(PropertyFormat.class)) {
                propertyFormat = field.getAnnotation(PropertyFormat.class);
                format = propertyFormat.value();
            }

            final IValueConverter valueConverter = ValueConverterFactory.getConverter(converterClass);
            PropertyBo propertyBo = PropertyBo.newInstance()
                    .field(field)
                    .propertyField(propertyField)
                    .propertyName(propertyName)
                    .converter(valueConverter)
                    .propertyEntry(propertyEntry)
                    .parentObject(bean)
                    .fieldName(fieldName)
                    .propertyFormat(propertyFormat)
                    .format(format);

            resultMap.put(propertyName, propertyBo);
        }

        return resultMap;
    }

}
