package com.github.houbb.property.support.converter;

import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.annotation.PropertyField;
import com.github.houbb.property.annotation.PropertyFormat;

import java.lang.reflect.Field;

/**
 * 值上下文接口
 * <p> project: property-IValueContext </p>
 * <p> create on 2019/11/20 20:10 </p>
 *
 * @author Administrator
 * @since 0.0.4
 */
public interface IValueContext {

    /**
     * 当前对象实例
     * @return 对象实例
     * @since 0.0.4
     */
    Object object();

    /**
     * 当前字段信息
     * @return 字段信息
     * @since 0.0.4
     */
    Field field();

    /**
     * 属性字段注解信息
     * @return 注解信息
     * @since 0.0.4
     */
    PropertyField propertyField();

    /**
     * 字段名称
     * @return 字段名称
     * @since 0.0.4
     */
    String fieldName();

    /**
     * 属性名称
     * @return 属性名称
     * @since 0.0.4
     */
    String propertyName();

    /**
     * 属性明细注解
     * @return 注解
     * @since 0.0.4
     */
    PropertyEntry propertyEntry();

    /**
     * 父类对象
     * @return 父类对象
     * @since 0.0.4
     */
    Object parentObject();

    /**
     * 父类字段
     * @return 父类字段
     * @since 0.0.4
     */
    Field parentField();

    /**
     * 属性名称前缀
     * @return 名称前缀
     * @since 0.0.4
     */
    String propertyNamePrefix();

    /**
     * 属性格式化
     * @return 格式化
     * @since 0.0.6
     */
    PropertyFormat propertyFormat();

    /**
     * 真正的格式化信息
     * @return 格式化信息
     * @since 0.0.6
     */
    String format();

}