package com.github.houbb.property.support.converter.context;

import com.github.houbb.property.annotation.PropertyEntry;
import com.github.houbb.property.annotation.PropertyField;
import com.github.houbb.property.annotation.PropertyFormat;
import com.github.houbb.property.support.converter.IValueContext;

import java.lang.reflect.Field;

/**
 * 值上下文默认实现
 *
 * @author binbin.hou
 * @since 0.0.4
 */
public class ValueContext implements IValueContext {

    /**
     * 当前对象实例
     *
     * @since 0.0.4
     */
    private Object object;

    /**
     * 当前字段信息
     *
     * @since 0.0.4
     */
    private Field field;

    /**
     * 属性字段注解信息
     *
     * @since 0.0.4
     */
    private PropertyField propertyField;

    /**
     * 字段名称
     *
     * @since 0.0.4
     */
    private String fieldName;

    /**
     * 属性名称
     *
     * @since 0.0.4
     */
    private String propertyName;

    /**
     * 注解明细信息
     * @since 0.0.4
     */
    private PropertyEntry propertyEntry;

    /**
     * 父类对象
     * @since 0.0.4
     */
    private Object parentObject;

    /**
     * 父类字段
     * @since 0.0.4
     */
    private Field parentField;

    /**
     * 属性名称前缀
     * @since 0.0.4
     */
    private String propertyNamePrefix;

    /**
     * 属性格式化
     * @since 0.0.6
     */
    private PropertyFormat propertyFormat;

    /**
     * 格式化信息
     * @since 0.0.6
     */
    private String format;

    /**
     * 新建一个对象实例
     *
     * @return 对象实例
     * @since 0.0.4
     */
    public static ValueContext newInstance() {
        return new ValueContext();
    }

    @Override
    public Object object() {
        return object;
    }

    public ValueContext object(Object object) {
        this.object = object;
        return this;
    }

    @Override
    public Field field() {
        return field;
    }

    public ValueContext field(Field field) {
        this.field = field;
        return this;
    }

    @Override
    public PropertyField propertyField() {
        return propertyField;
    }

    public ValueContext propertyField(PropertyField propertyField) {
        this.propertyField = propertyField;
        return this;
    }

    @Override
    public String fieldName() {
        return fieldName;
    }

    public ValueContext fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Override
    public String propertyName() {
        return propertyName;
    }

    public ValueContext propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    @Override
    public PropertyEntry propertyEntry() {
        return propertyEntry;
    }

    public ValueContext propertyEntry(PropertyEntry propertyEntry) {
        this.propertyEntry = propertyEntry;
        return this;
    }

    @Override
    public Object parentObject() {
        return parentObject;
    }

    public ValueContext parentObject(Object parentObject) {
        this.parentObject = parentObject;
        return this;
    }

    @Override
    public Field parentField() {
        return parentField;
    }

    public ValueContext parentField(Field parentField) {
        this.parentField = parentField;
        return this;
    }

    @Override
    public String propertyNamePrefix() {
        return propertyNamePrefix;
    }

    public ValueContext propertyNamePrefix(String propertyNamePrefix) {
        this.propertyNamePrefix = propertyNamePrefix;
        return this;
    }

    @Override
    public PropertyFormat propertyFormat() {
        return propertyFormat;
    }

    public ValueContext propertyFormat(PropertyFormat propertyFormat) {
        this.propertyFormat = propertyFormat;
        return this;
    }

    @Override
    public String format() {
        return format;
    }

    public ValueContext format(String format) {
        this.format = format;
        return this;
    }
}
