package com.github.houbb.property.support.converter.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.NumUtil;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.PrimitiveUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.IValueConverter;

import java.math.BigDecimal;

/**
 * 抽象 Number 值转换类
 *
 * @see     java.lang.Byte
 * @see     java.lang.Double
 * @see     java.lang.Float
 * @see     java.lang.Integer
 * @see     java.lang.Long
 * @see     java.lang.Short
 * @see     java.math.BigDecimal
 *
 * @author binbin.hou
 * @since 0.0.6
 */
@ThreadSafe
public abstract class AbstractNumberValueConverter<T extends Number> extends AbstractValueConverter<T> {

    /**
     * 获取具体的数字字段信息
     * @param value 值
     * @param context 上下文
     * @return 数字转化结果
     * @since 0.0.6
     */
    protected abstract T getNumberFieldValue(String value, IFieldValueContext context);

    @Override
    @SuppressWarnings("unchecked")
    protected T getFieldValue(String value, IFieldValueContext context) {
        String format = context.format();
        if(StringUtil.isNotEmpty(format)) {
            return (T) NumUtil.getFormatNum(value, format, context.field().getType());
        }

        return getNumberFieldValue(value, context);
    }

    @Override
    protected String getPropertyValue(T value, IPropertyValueContext context) {
        String format = context.format();
        if(StringUtil.isNotEmpty(format)) {
            return NumUtil.getNumFormat(value, format);
        }

        return value.toString();
    }

}
