package com.github.houbb.property.support.converter.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;
import com.github.houbb.heaven.util.lang.reflect.PrimitiveUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.IValueConverter;

/**
 * 抽象值转换类
 * @author binbin.hou
 * @since 0.0.5
 */
@ThreadSafe
public abstract class AbstractValueConverter<T> implements IValueConverter {

    /**
     * 获取字段的值
     * @param value 值
     * @param context 上下文
     * @return 结果
     * @since 0.0.5
     */
    protected abstract T getFieldValue(String value, IFieldValueContext context);

    /**
     * 获取属性的值
     * @param value 值
     * @param context 上下文
     * @return 结果
     * @since 0.0.5
     */
    protected abstract String getPropertyValue(T value, IPropertyValueContext context);

    @Override
    public Object fieldValue(String value, IFieldValueContext context) {
        Class fieldType = context.field().getType();

        // 基本类型返回默认值
        if(ClassTypeUtil.isPrimitive(fieldType)
            && StringUtil.isEmpty(value)) {
            return PrimitiveUtil.getDefaultValue(fieldType);
        }

        // 空值直接返回空
        if(StringUtil.isEmpty(value)) {
            return null;
        }

        // 其他常常处理逻辑
        return getFieldValue(value, context);
    }

    @Override
    @SuppressWarnings("unchecked")
    public String propertyValue(Object value, IPropertyValueContext context) {
        // 直接返回控制
        if(ObjectUtil.isNull(value)) {
            return StringUtil.EMPTY;
        }

        T t = (T)value;
        return getPropertyValue(t, context);
    }

}
