package com.github.houbb.property.support.converter.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.IValueConverter;

/**
 * 字符串数组转换类
 * @author binbin.hou
 * @since 0.0.3
 */
@ThreadSafe
public class StringArrayValueConverter implements IValueConverter {

    @Override
    public Object fieldValue(String value, IFieldValueContext context) {
        return StringUtil.splitToStringArray(value);
    }

    @Override
    public String propertyValue(Object value, IPropertyValueContext context) {
        String[] strings = (String[])value;
        return StringUtil.join(strings);
    }

}
