package com.github.houbb.property.support.converter.impl;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.lang.reflect.TypeUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.property.exception.PropertyRuntimeException;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.IValueConverter;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;

/**
 * 默认值转换类
 * @author binbin.hou
 * @since 0.0.3
 */
@ThreadSafe
public class StringCollectionValueConverter implements IValueConverter {

    @Override
    public Object fieldValue(String value, IFieldValueContext context) {
        itemClassCheck(context.field());

        if(StringUtil.isEmpty(value)) {
            return null;
        }

        final Class collectionClass = context.field().getType();
        String[] strings = StringUtil.splitToStringArray(value);
        Collection collection = TypeUtil.createCollection(collectionClass, strings.length);
        Collections.addAll(collection, strings);
        return collection;
    }

    @Override
    @SuppressWarnings("unchecked")
    public String propertyValue(Object value, IPropertyValueContext context) {
        itemClassCheck(context.field());

        // 循环处理
        Collection<String> stringCollection = (Collection<String>)value;
        return CollectionUtil.join(stringCollection);
    }

    /**
     * 元素类型检查
     * @param field 字段信息
     * @since 0.0.3
     */
    private void itemClassCheck(final Field field) {
        ArgUtil.notNull(field, "field");

        final Type collectionType = field.getGenericType();
        final Class itemClass = (Class) TypeUtil.getCollectionItemType(collectionType);
        if(String.class != itemClass) {
            throw new PropertyRuntimeException("Only support for collection write item String type, but found: " + itemClass);
        }
    }

}
