package com.github.houbb.property.support.converter.impl.aggregation;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

import java.util.List;

/**
 * @author binbin.hou
 * @since 0.0.7
 */
public class CharArrayValueConverter extends AbstractValueConverter<char[]> {

    @Override
    protected char[] getFieldValue(String value, IFieldValueContext context) {
        List<String> stringList = StringUtil.splitToList(value);
        return ArrayPrimitiveUtil.toCharArray(stringList, new IHandler<String, Character>() {
            @Override
            public Character handle(String s) {
                return s.charAt(0);
            }
        });
    }

    @Override
    protected String getPropertyValue(char[] value, IPropertyValueContext context) {
        return StringUtil.join(value);
    }

}
