package com.github.houbb.property.support.converter.impl.aggregation;

import com.github.houbb.heaven.support.handler.IHandler;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayPrimitiveUtil;
import com.github.houbb.property.support.converter.IFieldValueContext;
import com.github.houbb.property.support.converter.IPropertyValueContext;
import com.github.houbb.property.support.converter.impl.AbstractValueConverter;

import java.util.List;

/**
 * @author binbin.hou
 * @since 0.0.7
 */
public class LongArrayValueConverter extends AbstractValueConverter<long[]> {

    @Override
    protected long[] getFieldValue(String value, IFieldValueContext context) {
        List<String> stringList = StringUtil.splitToList(value);
        return ArrayPrimitiveUtil.toLongArray(stringList, new IHandler<String, Long>() {
            @Override
            public Long handle(String s) {
                return Long.valueOf(s);
            }
        });
    }

    @Override
    protected String getPropertyValue(long[] value, IPropertyValueContext context) {
        return StringUtil.join(value);
    }

}
